#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;

vector<int> bfs_path(int start, int end, const vector<vector<int>>& adj, const vector<int>& values) {
    int N = adj.size();
    vector<bool> visited(N, false);
    vector<int> parent(N, -1);
    queue<int> q;

    q.push(start);
    visited[start] = true;

    while (!q.empty()) {
        int u = q.front();
        q.pop();
        if (u == end) break; // ????? ??? ?? ?????????
        for (int v : adj[u]) {
            if (!visited[v]) {
                visited[v] = true;
                parent[v] = u;
                q.push(v);
            }
        }
    }

    vector<int> path_values;
    for (int v = end; v != -1; v = parent[v]) {
        path_values.push_back(values[v]);
    }
    return path_values;
}

int main() {
    int N, M, Q, P;
    cin >> N >> M >> Q >> P;

    vector<int> values(N);
    for (int& val : values) cin >> val;

    vector<vector<int>> adj(N);
    for (int i = 0; i < M; i++) {
        int u, v;
        cin >> u >> v;
        adj[u - 1].push_back(v - 1);
        adj[v - 1].push_back(u - 1);
    }

    int ansi = 0;
    while (Q--) {
        int a1, b1;
        cin >> a1 >> b1;
        int a = (a1 + ansi * P - 1) % N;
        int b = (b1 + ansi * P - 1) % N;

        vector<int> path_values = bfs_path(a, b, adj, values);
        sort(path_values.begin(), path_values.end());
        ansi = path_values[path_values.size() / 2];
        cout << ansi << endl;
    }

    return 0;
}